function [ok]=udpset(skt,name,data)
%function [ok]=udpset(skt,name,data)
% High level function for setting variables on PIC over udp
% calls udppoke to do its work
% udpset and udpget are the functions expected to be used normally
% updated for octave 4-Feb-2018 - Ian Stothers
hidx=find(skt.hash==sum(name+0));

if (max(size(hidx))>0)
 idx=findname(skt.name,name,hidx);
 if (min(size(idx)<1))
    error([name ' not found on target at IP '  sprintf('%s',get(skt.ip,'remotehost')) ]);
 end
 sda=size(data);
 data=reshape(data,1,sda(1)*sda(2));
 b=uint8(udpputconv(data,skt.type(idx)));
 msb=max(size(b));
 b=udppoke(skt,skt.ptr(idx),b(1:min(msb,skt.len(idx))));
 ok=1;
else
   error([name ' not found on target at IP '  sprintf('%s',get(skt.ip,'remotehost')) ]);
   ok=0;
end


